package ipsk.webapps.db.speech.filter;

import ipsk.db.speech.Project;
import ipsk.webapps.db.speech.ProjectController;

import java.io.IOException;
import java.util.List;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ProjectSelectFilter implements Filter {

	private static String PROJECT_SELECT_PAGE_PATH="/session/select_project.jsp";
	
	public void destroy() {
		// nothing to do
	}

	public void doFilter(ServletRequest arg0, ServletResponse arg1,
			FilterChain arg2) throws IOException, ServletException {
		boolean forwardable=!arg1.isCommitted();
		if (arg0 instanceof HttpServletRequest){
	           HttpServletRequest httpReq=(HttpServletRequest)arg0;
	           String user=httpReq.getRemoteUser();
	           HttpSession sess=httpReq.getSession(false);
	           if(sess!=null && user !=null && !httpReq.isUserInRole("ADMIN")){
	        	   
	        	   Object selectedProjectObj=sess.getAttribute("corpusmachine_project");
	        	   
	        	   if(selectedProjectObj==null){
	        		  
	        		   ProjectController prjCtrl=new ProjectController();
	        		   prjCtrl.open();
	        		   List<Project> assProjects=prjCtrl.getAssociatedProjects(httpReq);
	        		   int assProjCount=assProjects.size();
	        		   if(assProjCount==0){
	        			  // no project available
	        			   prjCtrl.close();
	        		   }else if(assProjCount==1){
	        			   sess.setAttribute("corpusmachine_project", assProjects.get(0).getName());
	        			   prjCtrl.close();
	        		   }else{
	        			   prjCtrl.close();
	        			   if(forwardable){
	        				   // forward to select page

	        				   RequestDispatcher rd = httpReq.getRequestDispatcher(PROJECT_SELECT_PAGE_PATH);
	        				   rd.forward(arg0, arg1);
	        				   return;
	        			   }
	        		   }   
	        	   }else{
	        		   
	        		   if(selectedProjectObj instanceof Project){
	        			   // we changed the type of the attribute from Project to ID of Project (String name)
	        			   // Tomcat is not able to serialize the Project objects to persist HTTP sessions
	        			   // the AudioFormat class is not serializable
		        		   String selectedProjectName=((Project)selectedProjectObj).getName();
		        		   // "convert"
		        		   sess.setAttribute("corpusmachine_project", selectedProjectName);
		        	   }
	        	   }
	           }
	       }
	       if (arg2!=null)arg2.doFilter(arg0,arg1);

	}

	public void init(FilterConfig arg0) throws ServletException {
		// nothing to do
	}

}
