<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"  %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true"%>
<fmt:setBundle basename="Messages" scope="request"/>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="organisation.details"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message key="organisation.details"/></h2>		 
 
<jsp:useBean id="orgaViewCtrl" scope="request" class="ipsk.webapps.db.speech.OrganisationController" />
<ips:ctrl_process controller="${orgaViewCtrl}">
<ips:bview bean="${orgaViewCtrl.item}" props="*" tableClass="db">
<ips:pview name="accounts" action="/db/account/Accounts.jsp"/>
<ips:pview name="persons" action="/db/person/Persons.jsp"/>
<ips:pview name="projects" action="/db/project/Projects.jsp"/>
<ips:pview name="sessions" action="/db/session/Sessions.jsp"/>
</ips:bview>
<c:if test="${orgaViewCtrl.item.accounts != null && fn:length(orgaViewCtrl.item.accounts) > 0}">
<h2><fmt:message key="accounts"/></h2>
<table>
<c:forEach items="${orgaViewCtrl.item.accounts}" var="orgaAccount">
<c:url scope="request" var="messageToOrgaURL" value="/session/msgs/MessageNew.jsp">
<c:param name="_cmd" value="new"/>
<c:param name="accountByToLogin.login" value="${orgaAccount.login}"/>
</c:url>
<tr><td><c:out value="${orgaAccount.login}"/></td><td><a href="${messageToOrgaURL}">[<fmt:message key="msgs.new"/>]</a></td></tr>
</c:forEach>
</table>
</c:if>

<h2><fmt:message key="sessions"/></h2>
<p><fmt:message key="sessions"/>: <a href="<ips:brelurl bean="${orgaViewCtrl.item}" action="/db/session/Sessions.jsp" property="sessions"/>">#<c:out value="${fn:length(orgaViewCtrl.item.sessions)}"/></a><br>
<fmt:message key="sessions.complete"/>: <c:out value="${orgaViewCtrl.completSessionsCount}"/></p>
<h2><fmt:message key="speakers"/></h2>
<p><fmt:message key="speakers.all_of_organisation"/>: <a href="<ips:brelurl bean="${orgaViewCtrl.item}" action="/db/speaker/Speakers.jsp" property="persons"/>">#<c:out value="${fn:length(orgaViewCtrl.speakersOfOrganisation)}"/></a></p>
<jsp:useBean id="orgaViewSpeakerCtrl" scope="request" class="ipsk.webapps.db.speech.SpeakerController" />

<c:set var="spkTblSize" value="10"/>
<fmt:message key="speakers.latest"><fmt:param value="${spkTblSize}"/></fmt:message>
<ips:ctrl_process controller="${orgaViewSpeakerCtrl}" batchSize="${spkTblSize}" namedQuery="speakers.byOrganisation.orderedByRegisteredDesc" param="${orgaViewCtrl.item}">
<ips:btable  tableClass="db" additionalCols="recordingFileCount" defColOrder="personId,forename,name,dateOfBirth,registered,sessions,recordingFileCount" beanVar="spk">
<ips:col name="sessions" href="/db/session/Sessions.jsp"/>

<ips:col name="recordingFileCount" key="recording_files">
<c:set var="spk_sessions" value="${spk.sessions}"/>
<c:set var="rfs" value="0"/>
<c:if test="${not empty spk_sessions}">
<c:forEach items="${spk_sessions}" var="sess"><c:set var="rfs" value="${rfs + fn:length(sess.recordingFiles)}"/></c:forEach></c:if>
<td>#<c:out value="${rfs}"/></td>
</ips:col>
</ips:btable>
<ips:items_position/>
</ips:ctrl_process>

</ips:ctrl_process>
</td></tr>
</table>
</body>
</html>
