function coeff_array=HTK_CreateParam(wavFile,fileType,paramType, SD_config)
% function coeff_array=HTK_CreateParam(wavFile,fileType,paramType,
%                                      SD_config)
%
% CVS_Version_String = '$Id: HTK_CreateParam.m,v 1.16 2004/05/01 09:16:43 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	mode = 'matlab';
	
	% for F0CEP
	F0_low = 80;
	F0_hi = 300;
	
	frameLength = round(SD_config.windowSize / SD_config.sourceRate);
	frameOverlap = round(SD_config.targetRate / SD_config.sourceRate);
	
	
	switch fileType
		case 'wav',	
			[wave,Fs]=readwav(wavFile,'rz');
			
		case 'raw',
			wave = read_raw_alaw(wavFile);
			wave = wave * 4096;
			Fs = round(1 / SD_config.sourceRate * 10*1000*1000); % source rate given as period of one sample in 100ns units
	end
	
	if (SD_config.useSilDet),
		wave = HTK_SigP_SilenceDetection( wave, SD_config);
	end
	
	

	if ((~isempty(findstr(paramType,'_E'))) & (findstr(paramType,'_E') == (length(paramType) - 1) )) %last string is _E
		has_Energy = 1;
		frames = enframe(wave,frameLength,frameOverlap);
		for i=1:size(frames,1),
			energy(i)=log(sum(frames(i,:) .* frames(i,:)));
		end
		paramType = paramType(1:(findstr(paramType,'_E')-1));
	else
		has_Energy = 0;
	end
	
	
	
	if (SD_config.preEmCoef>0),
		wave = HTK_SigP_PreEmphasis(wave, SD_config.preEmCoef);
	end

	
	ham_window = HTK_SigP_Hamming(ones(frameLength,1));
	
	if (SD_config.useHamming),
		frames = enframe(wave,ham_window,frameOverlap);
	else
		frames = enframe(wave,frameLength,frameOverlap);
	end
	
	NFrames = size(frames,1);
	fftSize = 2^(ceil(log2(length(frames(1,:)))));
	
	if (strcmp(mode,'HTK'))
		if (sum(strcmp(paramType,{'MELSPEC','FBANK','MFCC'}))),		
			fb_info = HTK_InitFBank(frameLength ,SD_config.sourceRate, SD_config.numChans, SD_config.loFreq, SD_config.hiFreq,  SD_config.usePower);
			melf_info = [];
		end
	else
		if (sum(strcmp(paramType,{'MELSPEC','FBANK','MFCC'}))),
			fb_info = [];
			melf_info = melbankm(SD_config.numChans,fftSize,Fs) / 2;
		end
	end
	if (strcmp(paramType,'LINCC')),
		lin_fb_info = lin_fbank(SD_config.numChans,fftSize,Fs,SD_config.loFreq, SD_config.hiFreq);
	end
	
	
	for i=1:NFrames,
	
		%disp(['frame: ' num2str(i) ]);
		switch paramType
		
			case 'MELSPEC',
				takeLogs = 0;
				coeff=HTK_SigP_Wave2FBank(frames(i,:),Fs,SD_config.numChans, melf_info, fb_info, takeLogs, mode);

			case 'FBANK',
				takeLogs = 1;
				coeff=HTK_SigP_Wave2FBank(frames(i,:),Fs,SD_config.numChans, melf_info, fb_info, takeLogs, mode);
			
			case 'MFCC',
				takeLogs = 1;
				fbank=HTK_SigP_Wave2FBank(frames(i,:),Fs,SD_config.numChans, melf_info, fb_info, takeLogs, mode);
				coeff = HTK_SigP_FBank2MFCC(fbank, SD_config.numCeps, mode);
				if (SD_config.cepLifter ~= 0),
					coeff = HTK_SigP_WeightCepstrum(coeff,SD_config.cepLifter);
				end
				
			case 'LINCC',
				coeff = linear_cepstrum(frames(i,:), Fs, SD_config.numChans, SD_config.numCeps, lin_fb_info);
				if (SD_config.cepLifter ~= 0),
					coeff = HTK_SigP_WeightCepstrum(coeff,SD_config.cepLifter);
				end
				
			case 'Cepstrum',
								
				SpecFrame = fft(frames(i,:),fftSize);
				fbank = ((abs(SpecFrame(1:(1+floor(fftSize/2)))))');
				log_fbank = log( max( [ ones(length(fbank),1)  fbank ], [], 2 ) );
				coeff=dct(log_fbank);
				coeff=coeff(2:(SD_config.numCeps+1));

			
			case 'F0CEP',
				coeff=HTK_SigP_Wave2F0Cep(frames(i,:),Fs,F0_low,F0_hi);

			case 'loudness_simple',
				coeff=calc_loudness_simple(frames(i,:),Fs);
				
			case 'loudness_zwicker',
				coeff=calc_loudness_zwicker(frames(i,:),Fs);
				
		end
	coeff_array(:,i)=coeff;
	end
	
	if (has_Energy),
		coeff_array((end+1), :) = energy; % append energy at end of each frame
	end

