function [eer, eer_coarse, threshold, threshold_coarse, fa_hits, fr_hits, fa_N_tests, fr_N_tests] = calc_EER_smoothing(FR_borders_in,FA_borders_in, plot_flag)
% function [eer, eer_coarse, threshold, threshold_coarse, fa_hits, fr_hits, fa_N_tests, fr_N_tests] = calc_EER_smoothing(FR_borders_in,FA_borders_in, plot_flag)
%
%
% CVS_Version_String = '$Id: calc_EER_smoothing.m,v 1.2 2003/12/02 12:15:54 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	if (nargin == 2)
		plot_flag = 0;
	end
	
	% not implemented here
	fa_hits = 0;
	fr_hits = 0;
	fa_N_tests = 0;
	fr_N_tests = 0;
	
	% borders erweitern
	FR_borders_in = [(FR_borders_in(1)-0.00001*abs(FR_borders_in(1))) FR_borders_in];
	FA_borders_in = [(FA_borders_in(1)-0.00001*abs(FA_borders_in(1))) FA_borders_in];
	% borders auf gleiche Eintrge berprfen / modifizieren
	temp = sort(FR_borders_in);
	temp_diff = diff(temp);
	index_duplicates = find(abs(temp_diff) < 1e-12);
	FR_borders = temp;
	if ~(isempty(index_duplicates))
		index_cell = get_index_2D_cell(index_duplicates);
		for set_counter=1:size(index_cell,1),
			curr_indizes=[index_cell{set_counter,:}] + 1;
			
			start_pointer = curr_indizes(1);
			end_pointer = curr_indizes(end);
			real_step = FR_borders(end_pointer + 1) - FR_borders(start_pointer);
			FR_borders(start_pointer:end_pointer) = FR_borders(start_pointer:end_pointer) + 0.1*abs( real_step )*(linspace((1/length(curr_indizes)),1, length(curr_indizes)));
		end
	end

	temp = sort(FA_borders_in);
	temp_diff = diff(temp);
	index_duplicates = find(abs(temp_diff) < 1e-12);
	%keyboard;	
	FA_borders = temp;
	if ~(isempty(index_duplicates))
		index_cell = get_index_2D_cell(index_duplicates);
		for set_counter=1:size(index_cell,1),
			curr_indizes=[index_cell{set_counter,:}] + 1;
			
			start_pointer = curr_indizes(1);
			end_pointer = curr_indizes(end);
			real_step = FA_borders(end_pointer + 1) - FA_borders(start_pointer);
			FA_borders(start_pointer:end_pointer) = FA_borders(start_pointer:end_pointer) + 0.1*abs( real_step )*(linspace((1/length(curr_indizes)),1, length(curr_indizes)));
		end
	end
	%keyboard;
	% gemeinsame x-Achse -> borders_common
	concat_borders = [FR_borders FA_borders];
	borders_common = sort(concat_borders);

	vector_length_fr=length(FR_borders) - 1;
	probabilities_fr = (1:vector_length_fr) / vector_length_fr * 100;
	probabilities_fr = [0 probabilities_fr];
	
	vector_length_fa=length(FA_borders) - 1;
	probabilities_fa = (1:vector_length_fa) / vector_length_fa * 100;
	probabilities_fa = [100 (100 - probabilities_fa)];
	%keyboard;

	% linear interpolation on common_borders
	FR_coarse_interpl = interp1(FR_borders, probabilities_fr, borders_common, 'linear');
	FA_coarse_interpl = interp1(FA_borders, probabilities_fa, borders_common, 'linear');

	
	if ( FR_borders(1) > FA_borders(end) ),
		% keine berschneidung von FA und FR
		%disp('calc_EER_smoothing: branch no overlap');
		eer = 0;
		eer_coarse = 0;
		threshold = ( FR_borders(1) - FA_borders(end) )/ 2;
		threshold_coarse = threshold;
		if (plot_flag == 1)
			temp_figure_handle = gcf;
			figure;
			plot(borders_common,FR_coarse_interpl,'w*');
			hold on;
			plot(borders_common,FA_coarse_interpl,'y*');
			figure(temp_figure_handle);
		end
		return;
	end

	% finde ungefhren Schnittpunkt
	diff_coarse=FA_coarse_interpl - FR_coarse_interpl;
	eer_index_coarse = find(diff_coarse < 0);
	
	index_begin = eer_index_coarse(1);
	sub_diff_prob = diff_coarse(index_begin-1:index_begin);
	sub_diff_borders = borders_common(index_begin-1:index_begin);
	
	
	eer_coarse = FR_coarse_interpl(index_begin);
	threshold_coarse = borders_common(index_begin);
	
	
	coeff_diff = polyfit(sub_diff_borders, sub_diff_prob,1);
	diff_roots = roots(coeff_diff);
	
	threshold = diff_roots;
	eer = FR_coarse_interpl(index_begin-1) + (FR_coarse_interpl(index_begin) - FR_coarse_interpl(index_begin-1)) / (sub_diff_borders(2) - sub_diff_borders(1)) * (threshold  - sub_diff_borders(1));	


	
	if (plot_flag == 1)
		if (isempty(get(0,'CurrentFigure')))
			temp_figure_handle = [];
		else
			temp_figure_handle = gcf;
		end
		figure;
		plot_start = max([(index_begin-2) 1]);
		plot_end = min([(index_begin+2) length(FA_coarse_interpl)]);
		sub_FR_prob = FR_coarse_interpl(plot_start:plot_end);
		sub_FA_prob = FA_coarse_interpl(plot_start:plot_end);
		sub_borders = borders_common(plot_start:plot_end);
		plot(sub_borders,sub_FR_prob,'w*');
		hold on;
		plot(sub_borders,sub_FA_prob,'y*');
		temp_axis = axis;
		plot(sub_borders,sub_FA_prob,'g');
		plot(sub_borders,sub_FR_prob,'g');
		axis(temp_axis);
		if (~isempty(temp_figure_handle))
			figure(temp_figure_handle);
		end
	end
	
	
	
	function index_cell = get_index_2D_cell(indizes)
	
		t=diff(indizes);
		
		set_no=1;
		index_cell{set_no,1}=indizes(1);
		
		for i=1:length(t)
			if (t(i) == 1)
				index_cell{set_no,end+1}=indizes(1+i);
			else
				set_no=set_no+1;
				index_cell{set_no,1}=indizes(1+i);
			end
		end

