function score_result_struct = calc_score_result_eer_part(score_result_struct, part_index, result_struct, ext_model_info, included_models, imp_spks_list, fr_sel_sessions, fa_sel_sessions)
% function score_result_struct = calc_score_result_eer_part(score_result_struct, 
%                                 part_index, result_struct, ext_model_info, 
%                                 included_models, imp_spks_list, fr_sel_sessions, fa_sel_sessions)
%
% CVS_Version_String = '$Id: calc_score_result_eer_part.m,v 1.10 2004/06/01 08:27:09 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	score_result_struct.part{part_index}.result_type = 'eer';

	num_of_models = length(included_models);

	[male_indizes, female_indizes]	= get_gender_indizes(included_models, ext_model_info);
	
	disp('EER part: Calculating eer rates ...');
	for i=1:num_of_models,
		absolute_index = strmatch(included_models(i), ext_model_info.trained_models,'exact');
		current_speaker = result_struct.FR_struct{absolute_index}.model_name;
		imp_spks_names = get_imp_speakers(imp_spks_list, {current_speaker},  result_struct.model_info,result_struct.FA_struct{absolute_index}.imp_test_spks);

		FR_rec_indizes = find_sessions_in_F_struct(result_struct.FR_struct{absolute_index}, fr_sel_sessions, {'all'}, ext_model_info);
		FA_rec_indizes = find_sessions_in_F_struct(result_struct.FA_struct{absolute_index}, fa_sel_sessions, imp_spks_names, ext_model_info);

		[eer, eer_coarse,threshold, threshold_coarse, fa_hits, fr_hits, fa_N_tests, fr_N_tests] = calc_EER(result_struct.FR_struct{absolute_index}.data.borders(FR_rec_indizes), result_struct.FA_struct{absolute_index}.data.borders(FA_rec_indizes));

		score_result_struct.part{part_index}.model(i).data = struct('eer',eer,'eer_coarse', eer_coarse,'threshold', threshold,'threshold_coarse', threshold_coarse, 'fa_hits', fa_hits, 'fr_hits', fr_hits, 'fa_N_tests', fa_N_tests, 'fr_N_tests', fr_N_tests);

		score_result_struct.part{part_index}.model(i).model_name=result_struct.FR_struct{absolute_index}.model_name;
		
	end

	
	score_result_struct.part{part_index}.parameters.eer_mean = mean(get_nested_field(score_result_struct.part{part_index}.model,'data.eer'));
	score_result_struct.part{part_index}.parameters.eer_std = std(get_nested_field(score_result_struct.part{part_index}.model,'data.eer'));
	score_result_struct.part{part_index}.parameters.threshold_mean = mean(get_nested_field(score_result_struct.part{part_index}.model,'data.threshold'));
	score_result_struct.part{part_index}.parameters.threshold_std = std(get_nested_field(score_result_struct.part{part_index}.model,'data.threshold'));

	% gender dependent, gender-balanced EERs
	
	eer_array = get_nested_field(score_result_struct.part{part_index}.model,'data.eer');
	eer_m = mean(eer_array(male_indizes));
	eer_f = mean(eer_array(female_indizes));
	
	eer_mf = mean([eer_m, eer_f]);

	score_result_struct.part{part_index}.parameters.eer_male_mean = eer_m;
	score_result_struct.part{part_index}.parameters.eer_female_mean = eer_f;
	score_result_struct.part{part_index}.parameters.eer_gender_balanced_mean = eer_mf;

	sum_fr_hits = sum(get_nested_field(score_result_struct.part{part_index}.model,'data.fr_hits'));
	score_result_struct.part{part_index}.parameters.fr_hits = sum_fr_hits;
	
	sum_fr_N_tests = sum(get_nested_field(score_result_struct.part{part_index}.model,'data.fr_N_tests'));
	score_result_struct.part{part_index}.parameters.fr_N_tests = sum_fr_N_tests;
	
	sum_fa_hits = sum(get_nested_field(score_result_struct.part{part_index}.model,'data.fa_hits'));
	score_result_struct.part{part_index}.parameters.fa_hits = sum_fa_hits;
	
	sum_fa_N_tests = sum(get_nested_field(score_result_struct.part{part_index}.model,'data.fa_N_tests'));
	score_result_struct.part{part_index}.parameters.fa_N_tests = sum_fa_N_tests;
	
