function indizes=draw_samples_from_pop( pop_indizes, sample_size )
% function indizes=draw_samples_from_pop( pop_indizes, sample_size )
%
% CVS_Version_String = '$Id: draw_samples_from_pop.m,v 1.1 2004/05/19 13:25:39 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	indizes = [];
	
	while (length(indizes) < sample_size),
	
		rnd_index = floor(rand(1) * length(pop_indizes)) + 1;
		
		if ( ~isempty(indizes) & ~(isempty(find( indizes == pop_indizes(rnd_index))))),
			% already in indizes
		else
			if (rnd_index <= length(pop_indizes)),
				indizes(end+1) = rnd_index;
			end	
		end
	end

