function combined_rec_indizes = find_combined_rec_indizes(F_struct, speakers, display_sessions, N_combination, ext_model_info)
% function combined_rec_indizes = find_combined_rec_indizes(F_struct, speakers, 
%                                  display_sessions, N_combination, ext_model_info)
%
% CVS_Version_String = '$Id: find_combined_rec_indizes.m,v 1.6 2003/11/04 10:34:06 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	if (N_combination == 1),
		combined_rec_indizes  = 1:length(F_struct.data.borders);
		return;
	end


	reduced_F_struct=decompose_F_struct(F_struct, speakers, 'with rec_info');
	combined_rec_indizes = [];

	for j=1:length(reduced_F_struct.data),
	% j: counter for speakers used when decomposing F_struct
		if (contained_in_cell('all', display_sessions)),
			search_sessions_cell = {'01','02','03','04','05','06','07','08','09','10','11','12','13','14','15','16','17','18','19','20'}; 
		elseif (contained_in_cell('without training', display_sessions)),
			if (isfield(ext_model_info.training_session_details,'type') & strcmp(ext_model_info.training_session_details.type, 'rec_list'))
				error('[find_combined_rec_indizes]: rec_list not supported!');
			else
				search_sessions_cell = get_diff_sessions_array(ext_model_info.training_session_details.sessions_evaluate_array, ext_model_info.training_session_details.sessions_training_array);
			end
		elseif (contained_in_cell('training', display_sessions)),
			if (isfield(ext_model_info.training_session_details,'type') & strcmp(ext_model_info.training_session_details.type, 'rec_list'))
				error('[find_combined_rec_indizes]: rec_list not supported!');
			else
				search_sessions_cell = ext_model_info.training_session_details.sessions_training_array;
			end		
		else
			search_sessions_cell = {};
			for i = 1:length(display_sessions),
				session_list_index = find_index_in_sessions_list( ext_model_info.preDefined,display_sessions{i} );
				search_sessions_cell = {search_sessions_cell{:} ext_model_info.preDefined{session_list_index}.item{:} };
				search_type = ext_model_info.preDefined{session_list_index}.type;
				if (strcmp(search_type, 'rec_list')),
					error('[find_combined_rec_indizes]: rec_list not supported!');
				end
			end
		end
		
		string_array = char(reduced_F_struct.data(j).rec_info);
		sessions_array = string_array(:,6:7);
		
		for i=1:length(search_sessions_cell),
			new_indizes = strmatch(search_sessions_cell{i}, sessions_array);
			combined_rec_indizes = [combined_rec_indizes get_combination_indizes(reduced_F_struct.data(j).original_index(new_indizes'), N_combination)];
		end
	
		%draw_rec_indizes = sort([draw_rec_indizes]);

	end

