function [imp_spks_cell, imp_spks_indizes] = get_imp_speakers(list_cell, current_speaker, model_info, spk_specific_imp_spks, varargin)
% function [imp_spks_cell, imp_spks_indizes] = get_imp_speakers(list_cell, current_speaker, model_info, spk_specific_imp_spks, [allowed_imp_spks = {all possible imp speakers}])
%
% Use: imp_spks_cell = {'all'} or {'all male'} or {'all female'} or {'same gender'} or {'cross-gender'}
% or: use a cell list of spks
% additionally: combine one of the keywords with a cell list
% -> cell list is used an filtered according to key word
% allowed_imp_spks serves as additional filter
%
% CVS_Version_String = '$Id: get_imp_speakers.m,v 1.6 2004/05/25 18:04:41 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

		if (nargin>=5),
			allowed_imp_spks = varargin{1};
		else
			allowed_imp_spks = {};
		end
		
		
		if (contained_in_cell('all',list_cell)),
			imp_spks_cell  = spk_specific_imp_spks;
			imp_spks_indizes = (1:length(imp_spks_cell));
			if (~ isempty( allowed_imp_spks ) ),
				[imp_spks_cell, ia, ib] = intersect( imp_spks_cell, allowed_imp_spks );
				imp_spks_indizes = imp_spks_indizes(ia);
			end
			
			return;
		end
		
		
		main_list = '';
		imp_spks_indizes = [];
		if (contained_in_cell('all male', list_cell)),
			main_list = 'all male';
		elseif (contained_in_cell('all female', list_cell)),
			main_list = 'all female';
		elseif (contained_in_cell('same gender', list_cell)),
			main_list = 'same gender';
		elseif (contained_in_cell('cross-gender', list_cell)),
			main_list = 'cross-gender';
		else
			main_list = 'only single spks';
		end
		
		[imp_male_indizes, imp_female_indizes]	= get_gender_indizes(spk_specific_imp_spks, model_info);
		switch main_list
			case 'all male',
				% male impostors
				imp_spks_indizes = imp_male_indizes;
			case 'all female',
				%female impostors
				imp_spks_indizes = imp_female_indizes;
			case 'same gender',
				% same gender impostors
				[male_ind, female_ind] = get_gender_indizes(current_speaker, model_info);
				if (sum(male_ind) == 1), % male client
					imp_spks_indizes = imp_male_indizes;
				else % female client
					imp_spks_indizes = imp_female_indizes;
				end
			case 'cross-gender',
				% cross-gender impostors
				[male_ind, female_ind] = get_gender_indizes(current_speaker, model_info);
				if (sum(male_ind) == 1), % male client
					imp_spks_indizes = imp_female_indizes;
				else % female client
					imp_spks_indizes = imp_male_indizes;
				end
		end

		
		
		single_imp_spk_list_indizes = strmatch('0', list_cell);
		if (~(isempty(single_imp_spk_list_indizes))),
			single_imp_spk_names = list_cell(single_imp_spk_list_indizes);
			[dummy_combined, single_imp_spks_indizes, dummy_indizes] = intersect(spk_specific_imp_spks,single_imp_spk_names);
			if (strcmp(main_list,'only single spks')),
				imp_spks_indizes = unique( [imp_spks_indizes single_imp_spks_indizes ] );
			else
				imp_spks_indizes = intersect( imp_spks_indizes, single_imp_spks_indizes );
			end
			
		end
		
		imp_spks_cell = spk_specific_imp_spks(imp_spks_indizes);


		if (~ isempty( allowed_imp_spks ) ),
			[imp_spks_cell, ia, ib] = intersect( imp_spks_cell, allowed_imp_spks );
			imp_spks_indizes = imp_spks_indizes(ia);
		end
		
