function rec_array = get_recs_by_S_list(S_list_file, sv_system_name, location, varargin)
% function rec_array = get_recs_by_S_list(S_list_file, sv_system_name, location)
%
% CVS_Version_String = '$Id: get_recs_by_S_list.m,v 1.11 2004/02/13 13:21:12 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



		
	%disp (set_type);
	
	if (nargin == 3),
		result_struct = [];
		
	elseif (nargin == 4)
		result_struct = varargin{1};
	else
		error('get_recs_by_S_list: wrong number of input arguments');
	end
		
	
	S_list_full_path = find_S_list_file(sv_system_name, S_list_file, location, result_struct);
	rec_array = read_S_list(S_list_full_path);

	if (strcmp(location,'world')),
		delete_multispeaker_file(sv_system_name);
	end
	
function S_list_cell = read_S_list(filename)
	line_cell=textread(filename,'%s','delimiter','\n','whitespace','');
	S_list_cell = {};
	for i = 1:length(line_cell)
		line = line_cell{i};
		slash_indizes=findstr(filesep, line);
		if (isempty(slash_indizes))
			error('[get_recs_by_S_list]: line in S_list does not contain slashes');
		end
		rec=line(slash_indizes(end)+1:end);
		ses=line(slash_indizes(end-1)+1:slash_indizes(end)-1);
		rec_type = rec(7:8);
		S_list_cell{i}.rec=rec;
		S_list_cell{i}.rec_type=rec_type;
		S_list_cell{i}.ses=ses;
	end


function S_list_full_path = find_S_list_file(sv_system_name, S_list_file, location, result_struct)
	SR_lib;
	if (strcmp(location,'model')),
		S_list_path = fullfile(basepath, sv_system_name, '0001');
	else
		% split off world_set spks and S_list_name
		slash_indizes=findstr(filesep, S_list_file);
		if (isempty(slash_indizes))
			S_list_path = fullfile(basepath, sv_system_name, '0001');
		else

			model_list = S_list_file(1:(slash_indizes(1)-1));
			S_list_single = S_list_file((slash_indizes(1)+1):end);
			S_list_file = 'S_list_tmp_for_matlab';
			S_list_path = fullfile(basepath, sv_system_name, 'tmp');
			build_multispeaker_file(sv_system_name, S_list_path, S_list_file, model_list, S_list_single, result_struct);
		
		end
	end
	dirstruct = dir(fullfile(S_list_path, 'S_list*'));
	found = 0;
	for i=1:length(dirstruct),
		if (strcmp(dirstruct(i).name, S_list_file))
			found = 1;
			break;
		end
	end
	if (found),
		S_list_full_path = fullfile(S_list_path, S_list_file);
	else
		error(['[get_recs_by_S_list]: could''t find required S_list_file ' S_list_file ' in ' S_list_path]);
	end

	
function build_multispeaker_file(sv_system_name, S_list_path, S_list_file, model_list, S_list_single, result_struct)
	
	SR_lib;
	
	if (isempty(result_struct)),
		sets = read_spk_set(sv_system_name);
	else 
		sets = result_struct.model_info.sets;
	end
	
	theModels = get_set(sets, model_list);
	% create empty target file 
	result = textwrite( fullfile(S_list_path , S_list_file), {} );
	
	for i=1:length(theModels),
		current_model = theModels{i};
		filename = fullfile(basepath, sv_system_name, current_model, S_list_single);
		line_cell=textread(filename,'%s','delimiter','\n','whitespace','');
		
		result = textwrite( fullfile(S_list_path, S_list_file), line_cell, 'a');
		
	
	end



function delete_multispeaker_file(sv_system_name)
	SR_lib;
	
	delete([basepath sv_system_name '/tmp/S_list_tmp_for_matlab']);
	

	
