function mlf_struct = join_mlf_structs(mlf_struct1, mlf_struct2)
% function mlf_struct = join_mlf_structs(mlf_struct1, mlf_struct2)
%
% CVS_Version_String = '$Id: join_mlf_structs.m,v 1.4 2003/11/04 10:34:06 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	mlf_struct.start_vector =  [mlf_struct1.start_vector uint16(double(mlf_struct2.start_vector) + double(mlf_struct1.end_time))];
	mlf_struct.phoneme_vector = [mlf_struct1.phoneme_vector mlf_struct2.phoneme_vector];
	mlf_struct.end_time = uint16(double(mlf_struct1.end_time) + double(mlf_struct2.end_time));
	
	if (isfield(mlf_struct1,'llh_values') & isfield(mlf_struct2,'llh_values')),
		mlf_struct.llh_values = [mlf_struct1.llh_values mlf_struct2.llh_values];
	end
	

