function mmf_struct=mod_hmm( mmf_struct, include_list, exclude_list )
% mmf_struct = mod_hmm( mmf_struct, include_list, exclude_list )
%
% CVS_Version_String = '$Id: mod_hmm.m,v 1.2 2004/04/01 14:32:53 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################
	
	if (strcmp(include_list, 'all')),
		include_items = 1:mmf_struct.vector_size;
	else
		include_items = include_list;
	end
	include_items = include_items( find((include_items > 0) & (include_items <= mmf_struct.vector_size) ) );
	
	if (strcmp(exclude_list, 'none')),
		% do nothing
		exclude_items = [];
	else
		exclude_items = exclude_list;
	end
	exclude_items = exclude_items( find((exclude_items > 0) & (exclude_items <= mmf_struct.vector_size) ) );
	
	items = zeros(1,mmf_struct.vector_size);
	items(include_items) = 1;
	items(exclude_items) = 0;
	
	selected_items = find(items == 1);
	
	
	
	
	for state_counter=1:length(mmf_struct.state),
	
			mmf_struct.state(state_counter).mean_vector = mmf_struct.state(state_counter).mean_vector(:,selected_items);
			mmf_struct.state(state_counter).variance_vector = mmf_struct.state(state_counter).variance_vector(:,selected_items);

	end
	
	
	mmf_struct.vector_size = length(selected_items);
	mmf_struct.vector_type = 'USER';
