function data_struct = read_world_llh_vs_it(base_dir, file_pattern_start)
% function data_struct = read_world_llh_vs_it(base_dir, file_pattern_start)
	
	cd(base_dir);
	ds=dir([file_pattern_start '*']);
	item_counter = 1;
	for dir_counter=1:length(ds),
		if (ds(dir_counter).isdir),
			cd(ds(dir_counter).name);
			feature_type = ds(dir_counter).name(length(file_pattern_start)+1:end);
			llh_array=[];
			llh_files=dir;
			llh_files=filter_directories(llh_files);
			[llh_files, it_number_array] = sort_by_it_number(llh_files);
			for file_counter=1:length(llh_files),
				value=textread( llh_files(file_counter).name , '%f',1);
				llh_array(file_counter)=value;
			end
			item_struct=struct('feature_type', feature_type, 'it_numbers', it_number_array, 'llh_values', llh_array);
			data_struct.data(item_counter)=item_struct;
			item_counter=item_counter + 1;
			cd('..');
		end
	end
	data_struct.name = file_pattern_start;
	
return;



	function new_llh_files = filter_directories(llh_files),
		
		entry_counter=1;
		for i=1:length(llh_files),
			if (~(llh_files(i).isdir)),
				new_llh_files(entry_counter) = llh_files(i);
				entry_counter=entry_counter+1;
			end	
		end
	return;
	
	function [new_llh_files, it_number_array] = sort_by_it_number(llh_files),

		it_number_array=[];
		for i=1:length(llh_files),
			underscore_ind=findstr('_',llh_files(i).name);
			underscore_ind=underscore_ind(end);
			end_ind=findstr('.mlf.txt',llh_files(i).name);
			it_number=llh_files(i).name(underscore_ind+1:end_ind -1);
			it_number_array(end+1)=str2num(it_number);
		end

		[it_number_array, sort_indizes] = sort(it_number_array);
		new_llh_files = llh_files( sort_indizes );
		
	return;
