function session_split = get_sessions_4_hnorm_type(split_type) 

	if (~(strcmp(split_type, 'Fixed/GSM')) & ~(strcmp(split_type, 'Quiet/Noisy'))),
		error('do_hnorm: split type is of wrong type, use ''Fixed/GSM'' or ''Quiet/Noisy''!');
	end
	
	switch split_type
	
	 	case 'Fixed/GSM'
			session_split{1} = {'FixedQuiet','FixedNoisy'}; % fixed
			session_split{2} = {'GSMQuiet','GSMNoisy'}; % gsm
			
	 	case 'Quiet/Noisy'
			session_split{1} = {'FixedQuiet','GSMQuiet'}; % quiet
			session_split{2} = {'FixedNoisy','GSMNoisy'}; % noisy	
	
	end

