% CVS_Version_String = '$Id: Plot_SR_parameters.m,v 1.7 2004/02/10 10:51:28 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


if (~exist('Results')),
	global Results;
end


if (~exist('Score_Results')),
	global Score_Results;
end

if (~exist('Score_Structs')),
	global Score_Structs;
end

if (~exist('rawdatapath')),
	global rawdatapath;
end

if (~exist('rawdatapath')),
	global basepath;
end

if (~exist('results_archive')),
	global results_archive;
end

if (~exist('lastUsedPath')),
	global lastUsedPath;
end

if (~exist('sessions_lists')),
	global sessions_lists;
end

if (~exist('audio_file_ext')),
	global audio_file_ext;
end

if (~exist('label_file_ext')),
	global label_file_ext;
end

SR_lib;

colordef black;
set(0,'DefaultfigureColor',[0 0 0]);
set(0,'DefaultFigureInvertHardCopy','off');

if ((isempty(Results)) & (isempty(Score_Results)) & (isempty(Score_Structs))),
	[result_index, score_result_index,score_struct_index, result_type]=Plot_SR_parameters_Callback('load');
elseif (~isempty(Results) & isempty(Score_Results)),
	result_index = 1;
	score_result_index = 0;
	score_struct_index = 0;
	result_type = 'result';
elseif (~isempty(Score_Results)  & isempty(Results)),
	result_index = 0;
	score_result_index = 1;
	score_struct_index = 0;
	result_type = 'score_result';
elseif ( ~isempty(Score_Results)  & ~isempty(Score_Results) )
	result_index = 1;
	score_struct_index = 0;
	full_result_name = Results{1}.full_name;

	found_flag = 0;
	found_index = 0;
	for i=1:length(Score_Results),
		if (strcmp(Score_Results{i}.full_name, full_result_name)),
			found_index = i;
			found_flag=1;
			break;
		end
	end

	if (found_flag),
		score_result_index = found_index;
		result_type = 'combined';
	else
		score_result_index = 0;
		result_type = 'result';
	end

else 
	result_index = 0;
	score_result_index = 0;
	score_struct_index = 1;
	result_type = 'score_struct';
end

fh=Plot_SR_parameters_init(result_index,score_result_index,score_struct_index,result_type, 'new window');

