function Dist_Struct = calc_model_distance_struct(sv_system_name, client_model_name, client_version, world_model_name, world_version, feature_set_struct, distance_type, mixture_mode, part_type)
% function Dist_Struct = calc_model_distance_struct(sv_system_name, client_model_name, 
%          client_version, world_model_name, world_hmm_name, feature_set_struct, 
%          distance_type, mixture_mode, part_type)
% 
% CVS_Version_String = '$Id: calc_model_distance_struct.m,v 1.9 2004/04/08 09:26:08 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

	
	
	client_hmm_name = 'gmmstate';
	%client_version = 1;
	world_hmm_name = 'gmmstate';
	%world_version = 1;
	
	%mixture_mode = 'use_max_mixture';
	
	SR_lib;
	
	if ( isempty(feature_set_struct) ),
		feature_set_struct(1).feature_set_name='all';
		feature_set_struct(1).include_list='all';
		feature_set_struct(1).exclude_list='none';
	end
	
	
	sets = read_spk_set('revert to standard set');
	model_info.sets = sets;
	trained_models = get_set(sets,'training_set');
	
	for i=1:length(trained_models),
		hmm_file_name=fullfile(basepath, sv_system_name, trained_models{i}, client_model_name, ['hmm.' num2str(client_version)], client_hmm_name);
		client_model_array{i}=mmf2matlab(hmm_file_name);
	end
	
	
	hmm_file_name=fullfile(basepath, sv_system_name, 'world', world_model_name, ['hmm.' num2str(world_version)], world_hmm_name);
	world_model=mmf2matlab(hmm_file_name);
	
	
	Dist_Struct.data={};
	for i = 1:(length(trained_models) + 1),
			
			if (i <= length(trained_models) ),
				mean_over_spks = [i];
			else
				mean_over_spks = 1:length(trained_models);
			end
			
			data = [];
			set_names={};
			
			for fs_set=1:length(feature_set_struct),
				
				distance_value=calc_model_distance(client_model_array, world_model, mean_over_spks, feature_set_struct, mixture_mode, distance_type, part_type);
				
				data(fs_set) = distance_value;
				set_names{fs_set} = feature_set_struct(fs_set).feature_set_name;
			end
			
			Dist_Struct.data{end+1}.distances=data;
			if (i <= length(trained_models) ),			
				Dist_Struct.data{end}.spk=trained_models{i};
			else
				Dist_Struct.data{end}.spk='all_trained';
			end
	end
	
	Dist_Struct.feature_set_names=set_names;
	Dist_Struct.feature_set_struct=feature_set_struct;
	Dist_Struct.model_info = model_info;
	Dist_Struct.client_model_name=client_model_name;
	Dist_Struct.client_version=client_version;
	Dist_Struct.world_model_name=world_model_name;
	Dist_Struct.world_version=world_version;
	Dist_Struct.mixture_mode = mixture_mode;
	Dist_Struct.distance_type = distance_type;
	Dist_Struct.part_type = part_type;
	
