function [result_struct, hnorm_param] = do_hnorm( result_struct, split_type, norming_result_struct)
% function [result_struct, hnorm_param] = do_hnorm( result_struct, split_type, norming_result_struct)
%
% CVS_Version_String = '$Id: do_hnorm.m,v 1.4 2004/05/04 12:09:37 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	SR_lib;
	
	session_split = get_sessions_4_hnorm_type(split_type);
	
	
	
	included_models = norming_result_struct.model_info.trained_models;
	
	imp_spks_list = {'same gender'};
	
	ext_model_info=create_ext_model_info(norming_result_struct.model_info);
	
	num_of_models = length(included_models);
	[male_indizes, female_indizes]	= get_gender_indizes(included_models, ext_model_info);

	
	hnorm_param.split_type = split_type;
	hnorm_param.session_split = session_split;
	
	
	% read mean and std of imp. scores
	for i=1:num_of_models,

		absolute_index = strmatch(included_models(i), ext_model_info.trained_models, 'exact');

		current_speaker = norming_result_struct.FA_struct{absolute_index}.model_name;
		imp_spks_names = get_imp_speakers(imp_spks_list, {current_speaker}, norming_result_struct.model_info, norming_result_struct.FA_struct{absolute_index}.imp_test_spks);

		hnorm_param.model{i}.model_name = current_speaker;
		
		disp(['do_hnorm: getting mean and std from norming imposters of spk ' current_speaker]);
		
		for s = 1:length(session_split),
			current_split_type = session_split{s};
			
			rec_indizes = find_sessions_in_F_struct(norming_result_struct.FA_struct{absolute_index}, current_split_type,imp_spks_names,ext_model_info);
			
			scores = norming_result_struct.FA_struct{absolute_index}.data.borders(rec_indizes);
			hnorm_param.model{i}.split{s}.scores_mean = mean(scores);
			hnorm_param.model{i}.split{s}.scores_std = std(scores);
		end
		
	end
	
	disp(' ');
	
	% renorm scores 
	for i=1:num_of_models,

		absolute_index = strmatch(included_models(i), ext_model_info.trained_models, 'exact');

		current_speaker = result_struct.FA_struct{absolute_index}.model_name;
		spks_names = {'all'};
		
		if (~(strcmp(hnorm_param.model{i}.model_name, current_speaker))),
			error('do_hnorm: mismatch between speakers in norming and normal result struct!');
		end
		
		disp(['do_hnorm: norming scores of spk ' current_speaker]);
		
		for s = 1:length(session_split),
			current_split_type = session_split{s};
			
			rec_indizes = find_sessions_in_F_struct(result_struct.FA_struct{absolute_index},current_split_type, spks_names, ext_model_info);
			
			scores = result_struct.FA_struct{absolute_index}.data.borders(rec_indizes);
			scores = (scores - hnorm_param.model{i}.split{s}.scores_mean) /	hnorm_param.model{i}.split{s}.scores_std;
			result_struct.FA_struct{absolute_index}.data.borders(rec_indizes) = scores;

			
			rec_indizes = find_sessions_in_F_struct(result_struct.FR_struct{absolute_index},current_split_type, spks_names, ext_model_info);
			
			scores = result_struct.FR_struct{absolute_index}.data.borders(rec_indizes);
			scores = (scores - hnorm_param.model{i}.split{s}.scores_mean) /	hnorm_param.model{i}.split{s}.scores_std;
			result_struct.FR_struct{absolute_index}.data.borders(rec_indizes) = scores;
			
		end
		
	end

