function plot_hmm_model(varargin)
% function plot_hmm_model(varargin)
%
% CVS_Version_String = '$Id: plot_hmm_model.m,v 1.6 2004/02/10 10:51:28 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	if (nargin == 1),
		action = varargin{1};
	else
		action = 'init';
	end
	
	SR_lib;
	

	switch action
	
		case 'init',
			
			[dirs, files, current_dir] = get_dir_content;
			if (length(current_dir) > 45)
				current_dir_display = [current_dir(1:45) ' ' current_dir(51:end)];
			else
				current_dir_display = current_dir;
			end
			pos = [50   277   850   500];
			pos_hmm_axes = [300 400 500 90];
			pos_param_axes = [25 15 500 350];
			hf=figure('Color',[0.1 0.1 0.1], ...
				'Position',pos, ...
				'Units','pixels', ...
				'Tag','mainHMMFigure');
			hmm_list_handle = uicontrol('Parent',hf, ...
				'Units','pixels', ...
				'BackgroundColor',[1 1 1], ...
				'Position',[190 410 100 80], ...
				'String',files, ...
				'Style','listbox', ...
				'Tag','hmms', ...
				'Callback','plot_hmm_model(''draw_model'');');
		    dirbox = uicontrol('style','listbox',...
			  	'position',[10 410 170 80],...
				'Units','pixels', ...
				'string',dirs,...
				'backgroundcolor','w',...
				'max',1,...
				'tag','dirbox',...
				'callback', 'plot_hmm_model(''update_dir_list'');');
		    path_info_handle = uicontrol('Parent',hf, ...
				'Units','pixels', ...
				'Position',[10 380 280 25], ...
				'Style','text', ...
				'String',current_dir_display, ...
				'Tag','path_info', ...
				'HorizontalAlignment','left');
			dist_button_handle = uicontrol('Parent',hf, ...
				'Units','pixels', ...
				'Position',[220 490 80 24], ...
				'String','load dist', ...
				'Tag','Dist_Button', ...
				'Callback','plot_hmm_model(''load_dist'');');				
			axes_hmm_handle = axes('Units','pixels',...
				'Position', pos_hmm_axes,...
				'Visible','off',...
				'Tag','axes_hmm');
			axes_param_handle = axes('Units','pixels',...
				'Position', pos_param_axes,...
				'Visible','on',...
				'Tag','axes_param');
			new_figure_handle = uicontrol('Parent',hf, ...
				'Units','pixels', ...
				'Position',[540 340 80 24], ...
				'Style','checkbox', ...
				'String','new figure', ...
				'Tag','new_figure');
			hold_handle = uicontrol('Parent',hf, ...
				'Units','pixels', ...
				'Position',[540 315 80 24], ...
				'Style','checkbox', ...
				'String','hold', ...
				'Tag','hold', ...
				'Callback','if get(gcbo,''Value'') plot_hmm_model(''hold_on''); else plot_hmm_model(''hold_off''); end');
			zoom_handle = uicontrol('Parent',hf, ...
				'Units','pixels', ...
				'Position',[540 290 80 24], ...
				'Style','checkbox', ...
				'String','zoom', ...
				'Tag','zoom', ...
				'Callback','zoom');
			zoomout_button_handle = uicontrol('Parent',hf, ...
				'Units','pixels', ...
				'Position',[539 264 80 24], ...
				'String','reset zoom', ...
				'Tag','Zoom_Button', ...
				'Callback','reset zoom');				
		    hmm_info_handle1 = uicontrol('Parent',hf, ...
				'Units','pixels', ...
				'Position',[300 385 280 15], ...
				'Style','text', ...
				'String','', ...
				'Tag','hmm_info1', ...
				'BackgroundColor',[0.1 0.1 0.1],...
				'ForegroundColor',[1 1 1],...
				'HorizontalAlignment','left');
		    hmm_info_handle2 = uicontrol('Parent',hf, ...
				'Units','pixels', ...
				'Position',[300 370 280 15], ...
				'Style','text', ...
				'String','', ...
				'Tag','hmm_info2', ...
				'BackgroundColor',[0.1 0.1 0.1],...
				'ForegroundColor',[1 1 1],...
				'HorizontalAlignment','left');
		    param_info_handle1 = uicontrol('Parent',hf, ...
				'Units','pixels', ...
				'Position',[540 70 160 15], ...
				'Style','text', ...
				'String','', ...
				'Tag','param_info1', ...
				'HorizontalAlignment','left');
		    param_info_handle2 = uicontrol('Parent',hf, ...
				'Units','pixels', ...
				'Position',[540 55 160 15], ...
				'Style','text', ...
				'String','', ...
				'Tag','param_info2', ...
				'HorizontalAlignment','left');
		    param_info_handle3 = uicontrol('Parent',hf, ...
				'Units','pixels', ...
				'Position',[540 40 160 15], ...
				'Style','text', ...
				'String','', ...
				'Tag','param_info3', ...
				'HorizontalAlignment','left');
		    param_info_handle4 = uicontrol('Parent',hf, ...
				'Units','pixels', ...
				'Position',[540 25 160 15], ...
				'Style','text', ...
				'String','', ...
				'Tag','param_info4', ...
				'HorizontalAlignment','left');
		    param_list_handle = uicontrol('style','listbox',...
			  	'position',[540 135 160 120],...
				'string','',...
				'backgroundcolor','w',...
				'max',2,...
				'tag','paramlist');
			draw_button_handle = uicontrol('Parent',hf, ...
				'Units','pixels', ...
				'Position',[540 110 80 24], ...
				'String','draw', ...
				'Tag','Draw_Button', ...
				'Callback','plot_hmm_model(''draw_param'');');				
			reset_button_handle = uicontrol('Parent',hf, ...
				'Units','pixels', ...
				'Position',[620 85 80 24], ...
				'String','reset', ...
				'Tag','Highlight_Button', ...
				'Callback','plot_hmm_model(''reset_param'')');				
			clear_button_handle = uicontrol('Parent',hf, ...
				'Units','pixels', ...
				'Position',[540 85 80 24], ...
				'String','clear', ...
				'Tag','Draw_Button', ...
				'Callback','plot_hmm_model(''clear_param'');');				
			hi_button_handle = uicontrol('Parent',hf, ...
				'Units','pixels', ...
				'Position',[620 110 80 24], ...
				'String','highlight', ...
				'Tag','Highlight_Button', ...
				'Callback','plot_hmm_model(''highlight_param'');');				
		
		case 'update_dir_list',
			s_handle=findobj(gcf,'Tag','dirbox');
			selected_item = get(s_handle,'Value');
			list = get(s_handle,'String');
			new_dir = list{selected_item};
			%whos new_dir;
			if (strcmp(new_dir,'..')),
				cd('..');
			else
				cd(new_dir);
			end
			[dirs, files, current_dir] = get_dir_content;
			set(s_handle,'Value',1);
			set(s_handle,'String',dirs);
			
			s_handle=findobj(gcf,'Tag','path_info');
			set(s_handle,'String',current_dir);
			
			s_handle=findobj(gcf,'Tag','hmms');
			set(s_handle,'String',files);
			set(s_handle,'Value',1);

	
		case 'draw_model'

			s_axes_handle=findobj(gcf,'Tag','axes_hmm');
			set(gcf,'CurrentAxes',s_axes_handle);
			cla;
			
			s_handle=findobj(gcf,'Tag','hmms');
			list = get(s_handle,'String');
			value = get(s_handle,'Value');
			modelfilename = list{value};
			
			mmf_struct = mmf2matlab(modelfilename);
			mmf_struct.modelfilename = modelfilename;
			
			s_handle=findobj(gcf,'Tag','dirbox');
			temp_ind = findstr(pwd,filesep);
			temp_path = pwd;
			mmf_struct.part_path = temp_path(temp_ind(end-4):end);
			
			rad_model = 1;
			dist_model = 3;
			hf=gcf;
			set(hf,'UserData',mmf_struct);
			
			set(s_axes_handle,'DataAspectRatio',[1 1 1]);
			axis([(-rad_model -1) (8 * dist_model ) (-rad_model) (rad_model)*3]);
			for i=1:mmf_struct.num_of_states;
				if (i == 1) | (i == mmf_struct.num_of_states),
					fill_mode='filled';
				else
					fill_mode='none';
				end
				[xp yp] = ellipse([((-rad_model)/2 + (i-1)*dist_model) (-rad_model / 2) rad_model rad_model]);
				xself = ([xp(43:49) xp(1:32)] - (i-1)*dist_model)*0.8 + (i-1)*dist_model;
				yself = [yp(43:49) yp(1:32)]*1.7 + 1.5*rad_model;
				h_models(i) = patch(xp, yp, 0);
				set(h_models(i), 'EdgeColor','w');
				set(h_models(i),'UserData',i);
				set(h_models(i),'ButtonDownFcn','plot_hmm_model(''init_draw_param'')');
				if (strcmp(fill_mode,'filled')),
					set(h_models(i), 'FaceColor',[0.1 0.1 0.25]);
				else
					set(h_models(i), 'FaceColor',[0 0 0]);
				end
				
				
				h_text(i) = text(((- 0.1 * rad_model) + (i-1)*dist_model), -rad_model*0.1, num2str(i));
				set(h_text(i),'FontSize',14);
				set(h_text(i),'UserData',i);
				set(h_text(i),'ButtonDownFcn','plot_hmm_model(''init_draw_param'')');
				
				if (i ~= mmf_struct.num_of_states),
					h_arrows_hor(i)=arrow([(dist_model*(i-1)+1*rad_model) 0],[(dist_model*i - 0.8*rad_model) 0],'Length',12);
					h_lines_hor(i)=line([(dist_model*(i-1)+1*rad_model) (dist_model*i - 1.1*rad_model)],[0 0],'Color','w');
					
					h_tr_hor(i) = text((dist_model*(i-0.5)), -0.7 ,num2str(mmf_struct.A(i,i+1),3));
					set(h_tr_hor(i),'HorizontalAlignment','center');	
				end
				if (i ~= mmf_struct.num_of_states) & (i ~= 1)
					h_lines_self(i)=line(xself,yself,'Color','w');
					h_arrows_self(i)=arrow([xself(end-3) yself(end-3)],[xself(end) yself(end)],'Length',14);
					h_tr_self(i) = text((dist_model*(i-1)), 3.0*rad_model ,num2str(mmf_struct.A(i,i),3));
					set(h_tr_self(i),'HorizontalAlignment','center');
				end
			end
			
			s_handle=findobj(gcf,'Tag','hmm_info1');
			set(s_handle,'String',['Feature vector type: ' mmf_struct.vector_type]);
			
			s_handle=findobj(gcf,'Tag','hmm_info2');
			set(s_handle,'String',['Feature vector size: ' num2str(mmf_struct.vector_size)]);
			
			
			
		case 'init_draw_param'
		
			model_state=get(gcbo,'UserData');
			mmf_struct =get(gcf,'UserData');
			
			s_axes_handle=findobj(gcf,'Tag','axes_param');
			set(s_axes_handle,'UserData',model_state);
			
			feature_description_list = get_description(mmf_struct.vector_type, mmf_struct.vector_size);
			s_param_list_handle=findobj(gcf,'Tag','paramlist');
            set(s_param_list_handle,'String',{'all' feature_description_list{:}});

			
			plot_hmm_model('draw_param');
						
		
		case 'load_dist'
			b_handle=findobj(gcf,'Tag','Dist_Button');
			
			ud_dist=get(b_handle,'UserData');
			
			if (~(isempty(ud_dist))),
				lastUsedPath=ud_dist.lastUsedPath;
			else
				ud_dist.lastUsedPath='';
				lastUsedPath='';
			end
			
			temp_path = pwd;
			
			cd(poolpath);
			
			[filename, used_path] = uigetfile([lastUsedPath 'hist*'],'Select histogram file:');
			
			if (used_path ~= 0)
				lastUsedPath = used_path;
			end
			
			cd(temp_path);
			
			if (filename == 0),
				ud_dist.lastUsedPath = lastUsedPath;
				set(b_handle,'UserData',ud_dist);
				return;
			end

			hist_struct = load_feature_distribution( [used_path filename] );
			
			ud_dist.hist = hist_struct;
			ud_dist.lastUsedPath = used_path;
			
			set(b_handle,'UserData',ud_dist);
			
			
		case 'show_single_param'
			s_handle1=findobj(gcf,'Tag','param_info1');
			s_handle2=findobj(gcf,'Tag','param_info2');
			s_handle3=findobj(gcf,'Tag','param_info3');
			s_handle4=findobj(gcf,'Tag','param_info4');
			
			u = get(gcbo,'UserData');
			set(s_handle1,'String',['Param. Type: ' u.desc]);
			set(s_handle2,'String',['mu: ' num2str(u.mu)]);
			set(s_handle3,'String',['sigma: ' num2str(u.sigma)]);
			set(s_handle4,'String',['weights: ' num2str(u.mixes)]);

		
		case 'draw_param'
		
			mmf_struct =get(gcf,'UserData');
		
			s_axes_handle=findobj(gcf,'Tag','axes_param');
			model_state=get(s_axes_handle,'UserData');
			
			feature_description_list = get_description(mmf_struct.vector_type, mmf_struct.vector_size);
			
			if (model_state == 1) | (model_state == 2 + length(mmf_struct.state)),
				% do nothing
				
			else
				set(gcf,'CurrentAxes',s_axes_handle);
				%hf = figure;
				set(gcf,'NumberTitle','off')
				set(gcf,'Name',['...' mmf_struct.part_path ', Model: ' mmf_struct.modelfilename ', State: ' num2str(model_state)])
				hold_status = ishold;
				if (~hold_status)
					cla;
					hold on;
				end
				colormap(jet);
				map=colormap;
				
				s_param_list_handle=findobj(gcf,'Tag','paramlist');
				
				param_list = get(s_param_list_handle,'Value') - 1;
				
				if (length(find(param_list==0)) ~= 0)
					% value 'all' in param_list
					param_list = (1:mmf_struct.vector_size);
				end
				for param_index=1:length(param_list),
					param = param_list(param_index);
					c_mixture = 1;
					for mix_c=1:mmf_struct.state(model_state-1).mix_number ,
						if (mmf_struct.state(model_state-1).mix_weight(mix_c) ~= 0)
							mu(c_mixture) = mmf_struct.state(model_state-1).mean_vector(mix_c,param);
							sigma(c_mixture) = sqrt(mmf_struct.state(model_state - 1).variance_vector(mix_c,param));
							weights(c_mixture) = mmf_struct.state(model_state-1).mix_weight(mix_c);
							c_mixture = c_mixture + 1;
						end
					end
					X_min_v = mu - 3*sigma;
					X_max_v = mu + 3*sigma;
					
					X=linspace(min(X_min_v),max(X_max_v),200);
					Y=zeros(1,length(X));
					
					for c_mixture=1:length(mu) ,
						Y=Y + (weights(c_mixture)  * normpdf(X,mu(c_mixture),sigma(c_mixture)) );
					end
					
					h_pdf(param)=line(X,Y,'Color',map(param+10,:));
					u.mu = mu;
					u.sigma = sigma;
					u.mixes = weights;
					u.color = map(param,:);
					u.desc = feature_description_list{param};
					u.selected = 0;
					set(h_pdf(param),'ButtonDownFcn','plot_hmm_model(''show_single_param'');');
					set(h_pdf(param),'Tag','pdf');
					set(h_pdf(param),'UserData',u);
				end
				
				
				b_handle=findobj(gcf,'Tag','Dist_Button');
				ud_dist=get(b_handle,'UserData');				
				if (~(isempty(ud_dist)) & (isfield(ud_dist,'hist'))),
					hist_struct=ud_dist.hist;
					for param_index=1:length(param_list),
						param = param_list(param_index);
						histogram=hist_struct.feature(param).histogram;
						x_hist=linspace(hist_struct.feature(param).min_exp,hist_struct.feature(param).max_exp, (hist_struct.feature(param).bin_size-1) );
						delta = x_hist(2)-x_hist(1);
						x_hist=[(x_hist(1) - 2*delta) (x_hist(1) - delta) x_hist (x_hist(1) + delta)];
						[xx, yy]=stairs(x_hist(1:end-1),histogram);
						xx=xx';
						yy=yy';
						nx=[xx(1) xx x_hist(end) x_hist(end)];
						ny=[0 yy  yy(end) 0];
						ny=ny*(1/delta);
						h_hist = plot(nx,ny,'w');
						set(h_hist,'Tag','hist');
					end
				end
				
				if (~hold_status)
					hold off;
				end
				
			end

			
		case 'highlight_param'
		
			s_axes_handle=findobj(gcf,'Tag','axes_param');
			model_state=get(s_axes_handle,'UserData');
			
			mmf_struct =get(gcf,'UserData');
			
			feature_description_list = get_description(mmf_struct.vector_type, mmf_struct.vector_size);
			
			
			if (model_state == 1) | (model_state == 2 + length(mmf_struct.state)),
				% do nothing
				
			else
				set(gcf,'CurrentAxes',s_axes_handle);
				%hf = figure;
				set(gcf,'NumberTitle','off')
				set(gcf,'Name',['...' mmf_struct.part_path ', Model: ' mmf_struct.modelfilename ', State: ' num2str(model_state)])
				
				s_param_list_handle=findobj(gcf,'Tag','paramlist');
				param_list_full = get(s_param_list_handle,'String');
				param_list_sel = get(s_param_list_handle,'Value');
				
				for i=1:length(param_list_sel)
					param_list_sel_detailed{i}=param_list_full{param_list_sel(i)};
				end
				
				s_handle = findobj(gcf,'Tag','pdf');
				u_cell  = get(s_handle,'UserData');
				for i=1:length(u_cell),
					u_desc{i} =u_cell{i}.desc;
				end
				
				for u_index=1:length(u_desc),
					
					if (contained_in_cell(u_desc{u_index},param_list_sel_detailed)),
						set(s_handle(u_index),'Color',[0 1 0]);
						u_temp = get(s_handle(u_index),'UserData');
						u_temp.selected = 1;
						set(s_handle(u_index),'UserData',u_temp);
					end
				end
			end

		case 'reset_param'
			s_handle = findobj(gcf,'Tag','pdf');
			u_cell  = get(s_handle,'UserData');
			%whos u_cell
			for i=1:length(u_cell),
				if (u_cell{i}.selected == 1)
					set(s_handle(i),'Color',u_cell{i}.color);
				end
			end
			s_axes_handle=findobj(gcf,'Tag','axes_param');
			ud = get(s_axes_handle,'UserData');
			reset(s_axes_handle);
			set(s_axes_handle, 'UserData', ud);
			set(s_axes_handle,'Tag','axes_param');
			
		case 'clear_param'
			s_handle=findobj(gcf,'Tag','pdf');
			delete(s_handle);
			
			s_handle=findobj(gcf,'Tag','hist');
			delete(s_handle);
			
		case 'hold_on'
			s_axes_handle=findobj(gcf,'Tag','axes_param');
			set(s_axes_handle, 'NextPlot', 'add');

		case 'hold_off'
			s_axes_handle=findobj(gcf,'Tag','axes_param');
			set(s_axes_handle, 'NextPlot', 'replace');
			
	end %switch action
	
% private

	function [dirs, files, current_dir] = get_dir_content

		platform_used = computer;
	
		if (strcmp(platform_used,'MAC2'))
			added_path_to_list = {'..'};
		else
			added_path_to_list = {};
		end
	
		d = dir;

		dirs = added_path_to_list;

		files = {};
		for item = 1:length(d),
			if (d(item).isdir),
				dirs = {dirs{:} d(item).name};
			else
				files = {files{:}, d(item).name};
			end
		end
		dirs = sort(dirs);
		files = sort(files);
		
		current_dir = pwd;
		
	
	function feature_description_list = get_description(type, size)
		
		switch type
			case 'LPCEPSTRA_E_D_A'
				counter = 1;
				for i=1:3
					switch i
						case 1,
							prefix = '';
						case 2,
							prefix = 'd ';
						case 3,
							prefix = 'd2 ';
					end
					for j=1:(size / 3 -1)
						feature_description_list{counter} = [prefix 'cep' num2str(j)];
						counter = counter + 1;
					end
					feature_description_list{counter} = [prefix 'E'];
					counter = counter + 1;
					
				end
				
			case 'USER'
				for j=1:size
					feature_description_list{j} = ['u' num2str(j)];
				end
		end
