#!/usr/bin/perl

# #####################################################
#
# This file is part of the Perl scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

my $CVS_Version_String = '$Id: cut_features.pl,v 1.4 2004/03/07 16:19:51 tuerk Exp $';
my $CVS_Name_String = '$Name: rel-1-4-01 $';

#use Time::HiRes qw(gettimeofday tv_interval);
use strict;

#my $t0 = [gettimeofday];

use FileHandle;
use Getopt::Long qw( GetOptions );

my $help = 0;
my $Identify = 0;

my @exclude_list = ();
my @include_list = ();

GetOptions('include=s' => \@include_list,
           'exclude=s' => \@exclude_list,
           'help|?' => \$help,
           'version' => \$Identify);

if ($Identify) {
	printf "$0\n$CVS_Version_String\n$CVS_Name_String\n\n"; 
}

@include_list = split( /,/, join(',', @include_list));
@exclude_list = split( /,/, join(',', @exclude_list));

if ((@ARGV != 2) || ($help)) {
   print "Usage: cut_features.pl [options] <infile> <outfile>\n";
   print "   options:\n";
   print "     -include= <comma seperated list of pos. numbers>\n";
   print "     -exclude= <comma seperated list of pos. numbers>\n";
   print "       default: all features\n\n";
   exit;
 }


my $in_file = $ARGV[0];
my $out_file = $ARGV[1];

###########################
my $display = 0;

my $parmKindMask = 0x3f;
my $crcQualMask = 010000;
my $compQualMask = 02000;
my $dataSize;

#my $t1 = [gettimeofday];

my $fh_in = &open_file("<", $in_file);
my $fh_out = &open_file(">", $out_file);

my $nSamples = &read_long($fh_in);
my $sampPeriod = &read_long($fh_in);
my $sampSize = &read_short($fh_in);
my $parmKind = &read_short($fh_in);

if ( ($parmKind & $parmKindMask) == 10) {
	$dataSize = 2;
}
else {
	$dataSize = 4;
}

if ( $parmKind & $compQualMask)  {
	die ("Cannot handle compressed data!\n");
}

if ( $parmKind & $crcQualMask) {
	$parmKind = $parmKind & (~ $crcQualMask);
}	
if ($display) {
	print STDERR "nSamples: $nSamples\n";
	print STDERR "sampPeriod: $sampPeriod\n";
	print STDERR "sampSize: $sampSize\n";
	print STDERR "parmKind: $parmKind\n";
	print STDERR "dataSize: $dataSize\n";

}
my $numFeatures = $sampSize / $dataSize;



if ( ( scalar @include_list ) == 0) {
	@include_list = (1 .. $numFeatures);
}

my @selected_list = ();
foreach (@include_list) {
	if (!(&test_containedInArray( $_, \@exclude_list))) {
		push(@selected_list, $_);
	}
}	
if ($display) {
	print STDERR "@selected_list \n";
}	
@selected_list = sort sorting_num (@selected_list);
$selected_list[$_] -= 1 foreach (0 .. $#selected_list);

if ($display) {
	print STDERR "@selected_list \n";
}	
my $newSampSize = (scalar @selected_list) * $dataSize;
&write_long($fh_out, $nSamples);
&write_long($fh_out, $sampPeriod);
&write_short($fh_out, $newSampSize);
&write_short($fh_out, $parmKind);

my @samplesArray = ( 1 .. $nSamples);
my @featuresOrigArray = ( 1 .. $numFeatures);
my @features;

my ($data, $data_length)=&read_from_file( $fh_in, $nSamples*$numFeatures*$dataSize );
if ($data_length != ($nSamples*$numFeatures*$dataSize) ) {
	die("could not read as many bytes as expecting\n");
}


#my $t2 = [gettimeofday];
my @temp_value = @selected_list;
my @all_items_list = ( 1 .. ($nSamples*$numFeatures) );
my @selected_list_exp = @selected_list;
foreach ( 2 .. $nSamples ) {
	foreach ( 0 .. $#selected_list) {
		$temp_value[$_] += $numFeatures;
	}	
	push (@selected_list_exp, @temp_value );
}

#print "@selected_list_exp \n";
if ($dataSize == 4) {

	for my $counter (@all_items_list[@selected_list_exp]){
		&write_long_raw($fh_out, substr($data, ($counter - 1)*$dataSize, 4));
		
	}
	#foreach (@samplesArray) {
	#	@features = ();
	#	for my $f_counter ( @featuresOrigArray) {
	#		$temp_value = &read_long_raw($fh_in);
	#	}
	#	
	#	foreach (@features[@selected_list]) {
	#		&write_long_raw($fh_out, $_);
	#	}
	#}
}
else {
	for my $counter (@all_items_list[@selected_list_exp]){
		&write_short_raw($fh_out, substr($data, ($counter - 1)*$dataSize, 2));
		
	}
	#foreach (@samplesArray) {
	#	@features = ();
	#	foreach ( @featuresOrigArray) {
	#		push (@features,  &read_short_raw($fh_in) );
	#	}
	#	
	#	foreach (@features[@selected_list]) {
	#		&write_short_raw($fh_out, $_);
	#	}
	#}

}

close ($fh_in);
close ($fh_out);

#my $t3=[gettimeofday];

#print STDERR "processing header: ", tv_interval($t1, $t2), "\n";
#print STDERR "processing feature data: " , tv_interval( $t2, $t3), "\n";
#print STDERR "processing overall: " , tv_interval( $t0, $t3), "\n";

exit 0;

sub test_containedInArray {
	my $testitem = $_[0];
	my $array_ref = $_[1];
	
	foreach my $item (@$array_ref) {
		if ($testitem eq $item) {
			return 1;
		}
	}
	return 0;
}

sub open_file {
	my ($filemode, $filename) = @_;
	my $filevar = new FileHandle;
	open ($filevar, $filemode . $filename) ||  die ("Can't open $filename");
	binmode ($filevar);
	return $filevar;
}

sub read_from_file {
	my ($filevar, $byte_num) = @_;
	my $result;
	my $length = read ($filevar, $result, $byte_num);
	return ($result,$length);
}

sub read_long {
	my ($fh) = @_;
	my $length = 4;
	
	my ($data, $length_read) = &read_from_file($fh, $length);

	if ($length_read != $length) {
		die ("error while reading, could not read to end while searching for long data\n");
	}

	return unpack("N", $data);
}

sub read_long_raw {
	my ($fh) = @_;
	my $length = 4;
	
	#my ($data, $length_read) = &read_from_file($fh, $length);
	my $data;
	my $length_read = read ($fh, $data, $length);
	if ($length_read != $length) {
		die ("error while reading, could not read to end while searching for long data\n");
	}

	return $data;
}

sub read_short {
	my ($fh) = @_;
	my $length = 2;

	my ($data, $length_read) = &read_from_file($fh, $length);
	if ($length_read != $length) {
		die ("error while reading, could not read to end while searching for short data\n");
	}

	return unpack("n", $data);
}

sub read_short_raw {
	my ($fh) = @_;
	my $length = 2;

	#my ($data, $length_read) = &read_from_file($fh, $length);
	my $data;
	my $length_read = read ($fh, $data, $length);
	if ($length_read != $length) {
		die ("error while reading, could not read to end while searching for short data\n");
	}

	return $data;
}


sub write_long {
	my ($filevar, $data) = @_;
	my $byte_num = 4;
	$data = pack("N", $data);
	syswrite ($filevar, $data, $byte_num);
}

sub write_long_raw {
	my ($filevar, $data) = @_;
	my $byte_num = 4;
	syswrite ($filevar, $data, $byte_num);
}


sub write_short {
	my ($filevar, $data) = @_;
	my $byte_num = 2;
	$data = pack("n", $data);
	syswrite ($filevar, $data, $byte_num);
}


sub write_short_raw {
	my ($filevar, $data) = @_;
	my $byte_num = 2;
	syswrite ($filevar, $data, $byte_num);
}


sub sorting_num { 
	my $retval;

	if ($a > $b) { 
			$retval = 1;
	} 
	elsif ($a == $b) {
			$retval = 0;
	} 
	else { 
			$retval = -1;
	}
	$retval; 
}
														
