function [LL, prior, transmat, mu, Sigma] = ...
     learn_ghmm(data, prior, transmat, mu, Sigma, varargin);
% LEARN_GHMM Compute the ML parameters of an HMM with  Gaussian output using EM
% [ll_trace, prior, transmat, mu, sigma] = learn_ghmm(data, prior0, transmat0, mu0, sigma0,  ...) 
%
% Same as learn_mhmm, except there is 1 mixture component per state.
% Hence we don't need to specify mixmat.
% All other optionl arguments are the same as learn_mhmm

Q = length(prior);
[LL, prior, transmat, mu, Sigma] = ...
    learn_mhmm(data, prior, transmat, mu, Sigma, ones(Q,1), varargin{:});

