## ----results='hide', message=F, warning=F--------------------------------
# Load the emuR package
library(emuR)

# Create demo data in directory provided by tempdir()
create_emuRdemoData(dir = tempdir())

# Copy this path and open it in your file manager
tempdir()

# Import the sample txt collection.
# When used with real data, sourceDir should point to the RECS directory of your
# SpeechRecorder project.
convert_txtCollection(dbName = "myEmuDatabase",
                      sourceDir = file.path(tempdir(), "emuR_demoData", "txt_collection"),
                      targetDir = tempdir())

## {

## ----results='hide', message=F, warning=F--------------------------------
dbHandle = load_emuDB(file.path(tempdir(), "myEmuDatabase_emuDB"))

## ----results='hide'------------------------------------------------------
summary(dbHandle)

## ----eval=F--------------------------------------------------------------
## serve(dbHandle)

## ----eval=FALSE----------------------------------------------------------
## runBASwebservice_g2pForTokenization(handle = dbHandle,
##                                     language = "eng-AU",
##                                     transcriptionAttributeDefinitionName = "transcription",
##                                     orthoAttributeDefinitionName = "Word")

## ----eval=FALSE----------------------------------------------------------
## runBASwebservice_g2pForPronunciation(handle = dbHandle,
##                                      language = "eng-AU",
##                                      orthoAttributeDefinitionName = "Word",
##                                      canoAttributeDefinitionName = "Canonical")

## ----eval=FALSE----------------------------------------------------------
## summary(dbHandle)
## serve(dbHandle)

## ----eval=FALSE----------------------------------------------------------
## runBASwebservice_maus(handle = dbHandle,
##                       language = "eng-AU",
##                       canoAttributeDefinitionName = "Canonical",
##                       mausAttributeDefinitionName = "Phonetic")

## ----eval=F--------------------------------------------------------------
## serve(dbHandle)

## ----eval = FALSE--------------------------------------------------------
## summary(dbHandle)
## # Name:	 myEmuDatabase
## # UUID:	 4a282f0a-62ee-435a-aead-b503ff002b6d
## # Directory:	 /private/var/folders/vh/j2k1_0395x5_sgzpbl4bzzl00000gn/T/Rtmpj0j4RT/myEmuDatabase_emuDB
## # Session count: 1
## # Bundle count: 7
## # Annotation item count:  293
## # Label count:  354
## # Link count:  272
## #
## # Database configuration:
## #
## # SSFF track definitions:
## # NULL
## #
## # Level definitions:
## #       name    type nrOfAttrDefs           attrDefNames
## # 1   bundle    ITEM            2 bundle; transcription;
## # 2     Word    ITEM            2       Word; Canonical;
## # 3 Phonetic SEGMENT            1              Phonetic;
## #
## # Link definitions:
## #          type superlevelName sublevelName
## # 1 ONE_TO_MANY         bundle         Word
## # 2 ONE_TO_MANY           Word     Phonetic

## ----eval=FALSE----------------------------------------------------------
## 
## convert_txtCollection(dbName = "myEmuDatabaseBASall",
##                       sourceDir = file.path(tempdir(), "emuR_demoData", "txt_collection"),
##                       targetDir = tempdir())
## dbHandleBASall = load_emuDB(file.path(tempdir(), "myEmuDatabaseBASall_emuDB"))
## 
## 
## runBASwebservice_all(handle = dbHandleBASall,
##                                     language = "eng-AU",
##                                     transcriptionAttributeDefinitionName = "transcription")
## 
## serve(dbHandleBASall)
## summary(dbHandleBASall)
## # Name:	 myEmuDatabase
## # UUID:	 7dd1a809-dcf4-49a4-9c55-a1b540dcea4d
## # Directory:	 /private/var/folders/vh/j2k1_0395x5_sgzpbl4bzzl00000gn/T/Rtmpj0j4RT/myEmuDatabase_emuDB
## # Session count: 1
## # Bundle count: 7
## # Annotation item count:  576
## # Label count:  691
## # Link count:  353
## #
## # Database configuration:
## #
## # SSFF track definitions:
## # NULL
## #
## # Level definitions:
## #    name    type nrOfAttrDefs           attrDefNames
## # 1 bundle    ITEM            2 bundle; transcription;
## # 2    ORT    ITEM            3         ORT; KAN; KAS;
## # 3    MAU SEGMENT            1                   MAU;
## # 4  MINNI SEGMENT            1                 MINNI;
## # 5    MAS    ITEM            1                   MAS;
## #
## # Link definitions:
## #         type superlevelName sublevelName
## # 1 ONE_TO_MANY         bundle          ORT
## # 2 ONE_TO_MANY            ORT          MAS
## # 3 ONE_TO_MANY            MAS          MAU

## ---- echo=FALSE, results='hide', message=FALSE--------------------------
# clean up emuR_demoData (in case it exists)
unlink(file.path(tempdir(), "emuR_demoData"), recursive = TRUE)
unlink(file.path(tempdir(), "myEmuDatabase_emuDB"), recursive = TRUE)

